// PaintView.cpp : implementation of the CPaintView class
//

#include "stdafx.h"
#include "Paint.h" //Includes resource.h
#include "PaintDoc.h"
#include "PaintView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//-----------My Paint Startup Defines----------------------
#define ERASE_RADIUS 10
#define LINEWIDTH 3
#define STARTLINECOLORCODE ID_COLOR_LINE_RED
#define STARTFILLCOLORCODE ID_COLOR_FILL_GREEN
#define STARTTOOLCODE ID_TOOL_PENCIL
 
//----------MyPaint helper functions-----------
/*Rather than separately prototyping the helper functions in the *.H
file, let's just protoype AND implement them at the head of the *.CPP file
so that the functions further down can use them. */


COLORREF code_to_color(UINT colorcode)
{
	switch(colorcode)
	{
		case ID_COLOR_LINE_RED:
		case ID_COLOR_FILL_RED:
			return RGB(255,0,0);
		case ID_COLOR_LINE_GREEN:
		case ID_COLOR_FILL_GREEN:
			return RGB(0,255,0);
		case ID_COLOR_LINE_BLUE:
		case ID_COLOR_FILL_BLUE:
			return RGB(0,0,255);
		default:
			return RGB(0,0,0);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CPaintView

IMPLEMENT_DYNCREATE(CPaintView, CView)

BEGIN_MESSAGE_MAP(CPaintView, CView)
	//{{AFX_MSG_MAP(CPaintView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_FILE_CLEAR, OnFileClear)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	/* ON_COMMAND_RANGE is a macro that maps a given range of select
		control IDs to the indicated message handler, which will have an
		nID argument equal to the control's ID. */
	ON_COMMAND_RANGE(ID_TOOL_PENCIL, ID_TOOL_ELLIPSE, OnTool)
	ON_COMMAND_RANGE(ID_COLOR_FILL_RED, ID_COLOR_FILL_BLUE, OnColorFill)
	ON_COMMAND_RANGE(ID_COLOR_LINE_RED, ID_COLOR_LINE_BLUE, OnColorLine)
	/*ON_UPDATE_COMMAND_UI_RANGE is a macro that maps a given range of update
		control IDs to the indicated message handler, which will have an
		argument that is a pointer to a CCmdUI object.  This object has a
		m_nID field with the ID of the control and it has a SetCheck method.*/
	ON_UPDATE_COMMAND_UI_RANGE(ID_TOOL_PENCIL, ID_TOOL_ELLIPSE, OnToolUpdate)
	ON_UPDATE_COMMAND_UI_RANGE(ID_COLOR_LINE_RED, ID_COLOR_LINE_BLUE,OnColorLineUpdate)
	ON_UPDATE_COMMAND_UI_RANGE(ID_COLOR_FILL_RED, ID_COLOR_FILL_BLUE, OnColorFillUpdate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPaintView construction/destruction

CPaintView::CPaintView():
//Use initializers to put default values in my special variables
	_pMemDC(NULL),
	_pMemDC_temp(NULL),
	_toolcode(STARTTOOLCODE),
	_linecolorcode(STARTLINECOLORCODE),
	_fillcolorcode(STARTFILLCOLORCODE),
	_cursorpoint(0,0),
	_oldcursorpoint(0,0),
	_got_lbuttondown(FALSE)
{
/* The HWND m_hWnd field of "this" isn't initialized yet when you hit this
	code, so you can't do _pMemDC = new cMemoryDC(this); here, you have
	to do that in OnCreate. */
}

CPaintView::~CPaintView()
{
	delete _pMemDC;
	delete _pMemDC_temp;
}

BOOL CPaintView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}
/////////////////////////////////////////////////////////////////////////////
// CPaintView printing

BOOL CPaintView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPaintView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPaintView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CPaintView drawing

void CPaintView::OnDraw(CDC* pDC)
{
	//Standard code.
	CPaintDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	//The CPaintView code
	RECT rect;

	pDC->GetClipBox(&rect);
	if (!pDC->IsPrinting())
		_pMemDC->copyTo(pDC, rect);
	else
		_pMemDC->stretchTo(pDC, rect, TRUE); 
	/* When the pDC is for print or print preview, it has a clip box rect of
	something like (-10, -10, 2000, 3000), and what happens if you do CopyTo
	is that you don't see anything at all.  Maybe your image gets squeezed up
	near (-10, -10), which isn't even visible in the print preview (off the
	upper left corner of the page). So we use a  cMemoryDC::stretchTo instead
	of the cMemoryDC::copyTo.  copyTo uses a straight BitBlt, while the
	stretchTo uses a StretchBlt.  The third argument to stretchTo is a BOOL
	fIsotropic, if this is TRUE, you stretch by the largest isotropic
	(same for x as for y) amount that fits within the target rect, this means,
	for instance, that a circle gets mapped into a circle rather than into
	an ellipse.  If the	flag is FALSE, you stretch to fill the rect and don't
	worry about preserving the x to y ratios.  
	*/
}


/////////////////////////////////////////////////////////////////////////////
// CPaintView diagnostics

#ifdef _DEBUG
void CPaintView::AssertValid() const
{
	CView::AssertValid();
}

void CPaintView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPaintDoc* CPaintView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPaintDoc)));
	return (CPaintDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPaintView message handlers


int CPaintView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	//Standard AFX code
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// My Code
	_pMemDC = new cMemoryDC(this);
	_pMemDC_temp = new cMemoryDC(this);
	return 0;
}

void CPaintView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	//My Code
		/* Each WM_LBUTTONDOWN needs to be paired with a WM_LBUTTONUP
			message and vice versa.  For many of the tools the former does
			some setup and the latter does some cleanup.  You need the
			WM_LBUTTONDOWN setup before processing the drag messages in
			WM_MOUSEMOUSE and the clean up in WM_LBUTTONUP.  So there are two
			problems that need to be avoided.  (i) you might left click in the
			client area, drag out of the client and release the left button out
			there.  (ii) You might left click outside of the client area,
			like in the menu bar, and then drag into the client are, later
			releasing the left button. In the first case you have a
			 WM_LBUTTONDOWN with no WM_LBUTTONUP, in the latter case you
			have WM_MOUSEMOVEs and a WM_LBUTTONUP with no WM_LBUTTONDOWN. */
			SetCapture(); /* This makes *all* mouse messages
				go to this window, and thus soves problem (i), because now
				a WM_BUTTONUP outside the client still goes to this program.
				An addded benefit is that you can drag ellipses, etc., outside
				the client and have them be there when you later enlarge the
				window. You undo this in WM_LBUTTONUP with ReleaseCapture.
				By the way, you wouldn't want SetCapture on ALL the time,
				because then you wouldn't be able to change the focus to
				another window by clicking outside your client region. */
			_got_lbuttondown = TRUE; /* This is to solve problem (ii).  The trick
				is that in WM_MOUSEMOVE, if you drag into the screen without
				having processesed a WM_LBUTTONDOWN, then _got_lbuttondown will
				be FALSE, and the WM_MOUSEMOVE code will know to send a
				WM_LBUTTDOWN message at the first point where you drag into the
				client area. We set _got_lbuttondown back to FALSE in
				WM_LBUTTONUP*/
			switch(_toolcode)
			{
				case ID_TOOL_PENCIL:
					_cursorpoint = point;
					break;
				case ID_TOOL_ERASER:
					OnMouseMove(nFlags, point);
					//Replaces SendMessage(m_hWnd, WM_MOUSEMOVE, MK_LBUTTON, lParam);
					break;
				case ID_TOOL_RECTANGLE:
				case ID_TOOL_ELLIPSE:
					_oldcursorpoint = point;
					break;
			}	
	//Default Code
	//CView::OnLButtonDown(nFlags, point);
}

void CPaintView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CPen cPen, *pPen_old;
	CBrush cBrush, *pBrush_old;
	RECT rect;

	//My Code
			if (nFlags & MK_LBUTTON)
			{
				if (!_got_lbuttondown)
				{ /* This is for the situation where I depress LBUTTON while
					in the menu bar and drag into the paint region.  In this case
					the program	doesn't get a	WM_LBUTTONDOWN message to do the
					setup for this tool.  To remedy this, we act like you
					did a WM_LBUTTONDOWN right	at the first point in the
					client area where you detect the drag. See the comment at
					the start of WM_LBUTTONDOWN for more explanation.  */
					OnLButtonDown(MK_LBUTTON, point);
					//replaces SendMessage(m_hWnd, WM_LBUTTONDOWN, MK_LBUTTON, lParam);
					return;
				}
			switch(_toolcode)
				{
					case ID_TOOL_PENCIL:
						_oldcursorpoint = _cursorpoint;
						_cursorpoint = point;
						cPen.CreatePen(PS_SOLID, LINEWIDTH, code_to_color(_linecolorcode));
						pPen_old = _pMemDC->SelectObject(&cPen);
						_pMemDC->MoveTo(_oldcursorpoint);
						_pMemDC->LineTo(_cursorpoint);
						_pMemDC->SelectObject(pPen_old);
/* The Win32 InvalidateRect(NULL, FALSE) call can be replaced
by the CWnd::Invalidate(FALSE) call.  Instead of havint to put
in a NULL as a first argument to signal that you want to invalidate
the whole window client rect like in InvalidateRect, the
Invalidate call assumes you do want to invalidate the whole rect.
The single boolean argument to Invalidate() says whether or not
to call CView::EraseBkGnd method to erase the background.  We
don't need to erase the background because our OnDraw covers the
whole window. */
						Invalidate(FALSE);
						break;
					case ID_TOOL_ERASER:
						_cursorpoint = point;
						_pMemDC->PatBlt(_cursorpoint.x - ERASE_RADIUS,
							_cursorpoint.y - ERASE_RADIUS,
							2*ERASE_RADIUS, 2*ERASE_RADIUS, WHITENESS);
						Invalidate(FALSE);
						break;
				case ID_TOOL_RECTANGLE:
				case ID_TOOL_ELLIPSE:
						_cursorpoint = point;
						/* Now copy the fixed _pMemDC stuff to _pMemDC_temp so you
							can draw a temporary shape on it. */
						GetClientRect(&rect); //How much of _pMemDC is visible?
						_pMemDC->copyTo(_pMemDC_temp, rect); //Copy _pMemDC to _pMemDC_temp
						cBrush.CreateSolidBrush(code_to_color(_fillcolorcode));
						cPen.CreatePen(PS_SOLID, LINEWIDTH,
							code_to_color(_linecolorcode));
						pPen_old = _pMemDC_temp->SelectObject(&cPen);
						pBrush_old = _pMemDC_temp->SelectObject(&cBrush);
						if (_toolcode == ID_TOOL_RECTANGLE)
							_pMemDC_temp->Rectangle(
									CRect(_oldcursorpoint, _cursorpoint));
						else //ID_TOOL_ELLIPSE case
							_pMemDC_temp->Ellipse(
									CRect(_oldcursorpoint, _cursorpoint));
						_pMemDC_temp->SelectObject(pBrush_old);
						_pMemDC_temp->SelectObject(pPen_old);
						CDC* pDC = GetDC(); //Get the screen hdc 
						_pMemDC_temp->copyTo(pDC, rect); //Copy _pMemDC_temp to the screen
						ReleaseDC(pDC); //Release the screen hdc
						break;
			} //end of switch on _toolcode
	} //end of if (wParam & MK_LBUTTON)
	//Default Code
	//CView::OnMouseMove(nFlags, point);
}

void CPaintView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CPen cPen, *pPen_old;
	CBrush cBrush, *pBrush_old;

	//My Code
	if (!_got_lbuttondown) //In case you didn't get (or simulate) a left down.
				return;
	switch(_toolcode)
	{
		case ID_TOOL_PENCIL:
		/*Draw one last segment of the line here just in case you
		never moved the mouse at all after WM_LBUTTONDOWN.  This
		ensures that the pencil tool makes at least one mark.  Note
		that a SendMessage is executed immediately, so that Windows goes
		and does WM_MOUSEMOVE before _got_lbuttondown is set to FALSE at the
		end of the WM_LBUTTONUP code.*/
			OnMouseMove(MK_LBUTTON, point);
		//replaces	SendMessage(m_hWnd, WM_MOUSEMOVE, MK_LBUTTON, lParam);
			break;
		case ID_TOOL_RECTANGLE:
		case ID_TOOL_ELLIPSE:
			_cursorpoint = point;
					cBrush.CreateSolidBrush(code_to_color(_fillcolorcode));
					cPen.CreatePen(PS_SOLID, LINEWIDTH, code_to_color(_linecolorcode));
					pPen_old = _pMemDC->SelectObject(&cPen);
					pBrush_old = _pMemDC->SelectObject(&cBrush);
					if (_toolcode == ID_TOOL_RECTANGLE)
						_pMemDC->Rectangle(_oldcursorpoint.x,
							_oldcursorpoint.y, _cursorpoint.x,
							_cursorpoint.y);
					else //ID_TOOL_ELLIPSE case
						_pMemDC->Ellipse(_oldcursorpoint.x,
							_oldcursorpoint.y, _cursorpoint.x,
							_cursorpoint.y);
					_pMemDC->SelectObject(pBrush_old);
					_pMemDC->SelectObject(pPen_old);
					Invalidate(FALSE); //Call WM_PAINT
					break;
			}
			ReleaseCapture(); /*Undoes the SetCapture(m_hWnd) call
				in WM_LBUTTONDOWN, so again only mouse in window counts.  See
				comment at start of WM_LBUTTONDOWN for a full explanation.*/
			_got_lbuttondown = FALSE; /* Tells program that it is again waiting
				for a WM_LBUTTONDOWN from inside the client region.  See
				comment at start of WM_LBUTTONDOWN for a full explanation.*/
	//Default Code
	//CView::OnLButtonUp(nFlags, point);
}


void CPaintView::OnFileClear() 
{
	_pMemDC->clear();
	Invalidate(FALSE);	
}

void CPaintView::OnTool(UINT nID) 
{
	_toolcode = nID;
}

void CPaintView::OnColorLine(UINT nID) 
{
	_linecolorcode = nID;
}

void CPaintView::OnColorFill(UINT nID) 
{
	_fillcolorcode = nID;
}

void CPaintView::OnToolUpdate(CCmdUI *pCmdUI) 
{/*This handler will be called for each of the tool control codes, passing in a
	pointer to the CCmdUI object corresonding to the control. This object has a
	m_nID field with the ID of the control and it has a SetCheck method.
	We use the CCmdUI SetCheck method, which can have an argument of 0, 1, or 2 
	(2 is for	indeterminate, used only on toolbars).*/ 
	int isactive = (pCmdUI->m_nID == _toolcode)?1:0;
	pCmdUI->SetCheck(isactive);
}

void CPaintView::OnColorLineUpdate(CCmdUI *pCmdUI) 
{  //Ranges over Line Color controls. See comment in CPaintView:OnToolUpdate
	int isactive = (pCmdUI->m_nID == _linecolorcode)?1:0;
	pCmdUI->SetCheck(isactive);
}

void CPaintView::OnColorFillUpdate(CCmdUI *pCmdUI) 
{  //Ranges over Fill Color controls. See comment in CPaintView:OnToolUpdate
	int isactive = (pCmdUI->m_nID == _fillcolorcode)?1:0;
	pCmdUI->SetCheck(isactive);
}

